//
//  AdViewVideo.h
//  AdViewHello
//
//  Created by AdView on 2018/8/1.
//

#import "AdViewViewDelegate.h"

@class AdViewVideo;

@protocol AdViewVideoDelegate <AdViewGDPRProcotolV1, AdViewGDPRProcotolV2, AdViewBidModeProtocol>
@optional
//***** ADVideoTypeInstl The application callback

/*
 * The video can start playing after this callback is called showVideoWithController: Show video ads
 */
- (void)adViewVideoIsReadyToPlay:(AdViewVideo *)video;

/*
 * Video ads start to play back
 */
- (void)adViewVideoPlayStarted;

/*
 * Video AD playback end callback
 */
- (void)adViewVideoPlayEnded;

/*
 * Video AD close callback
 */
- (void)adViewVideoClosed;

/*
 * Ads skip callbacks
 */
- (void)adViewVideoSkipped;

/*
 * Video ads click back
 */
- (void)adViewVideoClicked;

//***** AdViewVideoTypePreMovie The application callback
/*
 * Request a successful callback for advertising data
 * @param vastString:Returns the video content string in patch mode (vast protocol standard); Nil in non-patch mode;;
 */

- (void)adViewVideoDidReceiveAd:(NSString *)vastString;

/*
 * Failed to request a callback for advertising data
 * @param error:Data loading failure error message; (The playback failure callback is also included in the callback.)
 */
- (void)adViewVideoFailReceiveDataWithError:(NSError*)error;
@end

@interface AdViewVideo : NSObject
@property (nonatomic, assign) BOOL enableGPS; // Whether to enable the function of obtaining location information. The default value is NO

+ (AdViewVideo *)playVideoWithAppId:(NSString *)appId
                         positionId:(NSString *)positionID
                          videoType:(AdViewVideoType)videoType
                           delegate:(id<AdViewVideoDelegate>)videoDelegate;

/**
 * Loading video ads
 */
- (void)getVideoAD;

/**
 In the bid mode, you should call it when the delegate method [adViewObject:didReceiveBidPrice:] called back and ther price win.
 It will request ad content & report a result.
 */
- (void)bidSuccess;

/**
 Similar to the use of SEL: bidSuccess.
 It only reports a result
 */
- (void)bidFailure;

/**
 Set the video display direction

 @param orientation The video display direction is portrait by default（UIInterfaceOrientationPortrait）
 */
- (void)setInterfaceOrientations:(UIInterfaceOrientation)orientation;


/**
 * Set the background color of the video. The default color is black. You are advised to use it before showVideoWithController:; otherwise, the delay takes effect
 */
- (void)setVideoBackgroundColor:(UIColor*)backgroundColor;

/**
 * Display ads, AdViewVideoIsReadyToPlay: after the callback invocation, or show not to come out；
 */
- (BOOL)showVideoWithController:(UIViewController *)controller;

/**
 * Whether to display the traffic reminder box (use this function when non-wifi and no cache)
 * @param isShow Whether to display (YES indicates display, default is NO）
 */
- (void)isShowTrafficReminderView:(BOOL)isShow;

/**
 * Clearing the video cache
 */
- (void)clearVideoBuffer;

@end
